FlatUX Theme for RetroArch & Lakka
====================

About FlatUX
-----------------

FlatUX is a theme that is intended to replace the FlatUI and Retroactive themes.  FlatUI is one of the pioneering themes that was created for the Libretro XMB and was designed to be an alternative to the default Monochrome theme.  Retroactive is a theme that set out to colorize the Monochrome theme.  

For years, FlatUI had an incomplete set of icons with a call to contributors to complete the set. In 2022, [baxysquare] (https://github.com/baxysquare/) decided to merge FlatUI and Retroactive into a single theme in order to complete both theme projects in a satisfactory manner. The RetroActive icons had their borders removed and were recolored with the expanded FlatUI color palette to become the FlatUX theme. 

Source files for development of this theme can be found at https://github.com/baxysquare/baxy-retroarch-themes

Guidelines
----------

### Palette

 * Icons use the 40 color expanded FlatUI palette found in the color palette folder. 
 * Use of gradients and translucency is prohibited in favor of maintaining a flat look.

### Layout

 * The design should be easily recognizable.
 * The icons should be set to a 256x256 canvas and should be centered on a 64x64 grid. Snap design elements to the grid wherever possible to provide maximum clarity and scalability.
 * The icon must have a 16px margin, effectively reducing the icon size to 232x232.
 
### Style

 * The level of detail is expanded beyond the scope of the monochrome set, but favors flat design and recognizability over absolute realism.

### Export
 * The original source files were created with Adobe Illustrator and saved as PDF files. The SVG and PNG files can be created using the ImageMagick Mogrify command.

Colophon
----------

### Theme Font
 * This theme uses the [Open Sans](http://mplus-fonts.osdn.jp/design.html#mplus_p1) typeface by the [Steve Matteson](https://twitter.com/@SteveMatteson1) covered under the [Apache License, Version 2.0](http://www.apache.org/licenses/LICENSE-2.0).