/*
   Bob-and-ghost Deinterlacing
   Author: hunterk
   License: Public domain
   
   Note: This shader is designed to work with the typical interlaced output from an emulator, which displays both even and odd fields twice.
   As such, it is inappropriate for general video use unless the video has already been similarly woven beforehand.
*/

#if defined(VERTEX)

#if __VERSION__ >= 130
#define COMPAT_VARYING out
#define COMPAT_ATTRIBUTE in
#define COMPAT_TEXTURE texture
#else
#define COMPAT_VARYING varying 
#define COMPAT_ATTRIBUTE attribute 
#define COMPAT_TEXTURE texture2D
#endif

#ifdef GL_ES
#define COMPAT_PRECISION mediump
#else
#define COMPAT_PRECISION
#endif

COMPAT_ATTRIBUTE vec4 VertexCoord;
COMPAT_ATTRIBUTE vec4 COLOR;
COMPAT_ATTRIBUTE vec4 TexCoord;
COMPAT_VARYING vec4 COL0;
COMPAT_VARYING vec4 TEX0;

vec4 _oPosition1; 
uniform mat4 MVPMatrix;
uniform COMPAT_PRECISION int FrameDirection;
uniform COMPAT_PRECISION int FrameCount;
uniform COMPAT_PRECISION vec2 OutputSize;
uniform COMPAT_PRECISION vec2 TextureSize;
uniform COMPAT_PRECISION vec2 InputSize;

// compatibility #defines
#define vTexCoord TEX0.xy
#define SourceSize vec4(TextureSize, 1.0 / TextureSize) //either TextureSize or InputSize
#define OutSize vec4(OutputSize, 1.0 / OutputSize)

void main()
{
    gl_Position = MVPMatrix * VertexCoord;
    TEX0.xy = TexCoord.xy;
}

#elif defined(FRAGMENT)

#ifdef GL_ES
#ifdef GL_FRAGMENT_PRECISION_HIGH
precision highp float;
#else
precision mediump float;
#endif
#define COMPAT_PRECISION mediump
#else
#define COMPAT_PRECISION
#endif

#if __VERSION__ >= 130
#define COMPAT_VARYING in
#define COMPAT_TEXTURE texture
out COMPAT_PRECISION vec4 FragColor;
#else
#define COMPAT_VARYING varying
#define FragColor gl_FragColor
#define COMPAT_TEXTURE texture2D
#endif

uniform COMPAT_PRECISION int FrameDirection;
uniform COMPAT_PRECISION int FrameCount;
uniform COMPAT_PRECISION vec2 OutputSize;
uniform COMPAT_PRECISION vec2 TextureSize;
uniform COMPAT_PRECISION vec2 InputSize;
uniform sampler2D Texture;
COMPAT_VARYING vec4 TEX0;

// compatibility #defines
#define Source Texture
#define vTexCoord TEX0.xy

#define SourceSize vec4(TextureSize, 1.0 / TextureSize) //either TextureSize or InputSize
#define OutSize vec4(OutputSize, 1.0 / OutputSize)

#define one_pixel vec2(1.0 / TextureSize)

vec4 bob_and_ghost(vec2 texture_size, vec2 video_size, float frame_count, vec2 texCoord, sampler2D tex)
{
	vec4 res = vec4(pow(COMPAT_TEXTURE(tex, texCoord), vec4(2.2)));
	vec4 color = vec4(0.,0.,0.,0.);
	float y = 0.0;

	// assume anything with a vertical resolution greater than 400 lines is interlaced
	if (video_size.y > 400.0) 
	{
		y = texture_size.y * texCoord.y + frame_count;
		res = pow(vec4(COMPAT_TEXTURE(tex, texCoord + vec2(0.0, one_pixel.y))), vec4(2.2));
		color = pow((vec4(COMPAT_TEXTURE(tex, texCoord - vec2(0.0, 0.5 * one_pixel.y))) + vec4(COMPAT_TEXTURE(tex, texCoord + vec2(0.0, 0.5 * one_pixel.y)))) / 2.0, vec4(2.2));
	}
	else
	{
		y = 2.000001 * texture_size.y * texCoord.y;
		color = res;
	}

	if (mod(y, 2.0) > 0.99999) res = res;
	else res = vec4(pow(COMPAT_TEXTURE(tex, texCoord), vec4(2.2)));
	return vec4(pow((res + color) / vec4(2.,2.,2.,2.), vec4(1.0 / 2.2, 1.0 / 2.2, 1.0 / 2.2, 1.0 / 2.2)));
}

void main()
{
    FragColor = bob_and_ghost(TextureSize, InputSize, float(FrameCount), TEX0.xy, Texture);
} 
#endif
